# Operationalisierung der abängigen Variable
# Nach Cohen / Nordas 2014

# Maximum Prevalence Levels Across the Three Sources (p.6)
Master$max_prev <- apply(Master[c("state_prev", "ai_prev", "hrw_prev")], 1, max, na.rm=T)
Master$max_prev[is.infinite(Master$max_prev) | is.nan(Master$max_prev)] <- NA

# Minimum (nicht bei Cohen/Nordas)
Master$min_prev <- apply(Master[c("state_prev", "ai_prev", "hrw_prev")], 1, min, na.rm=TRUE)
Master$min_prev[is.infinite(Master$min_prev) | is.nan(Master$min_prev)] <- NA

# Gerundeter Mean (nicht bei Cohen/Nordas)
Master$mean_prev <- rowMeans(Master[c("state_prev", "ai_prev", "hrw_prev")], na.rm=TRUE)
Master$mean_prev <- round(Master$mean_prev, digits = 0)
Master$mean_prev[is.infinite(Master$mean_prev) | is.nan(Master$mean_prev)] <- NA

# Median Prevalence Levels Across the Three Sources (p.8)
Master$median_prev <- apply(Master[c("state_prev", "ai_prev", "hrw_prev")], 1, median, na.rm=TRUE)
Master$median_prev <- round(Master$median_prev, digits = 0)
Master$median_prev[is.infinite(Master$median_prev) | is.nan(Master$median_prev)] <- NA

# descriptive statistics
#mean(Master$state_prev, na.rm = T)
#mean(Master$ai_prev, na.rm = T)
#mean(Master$hrw_prev, na.rm = T)
#mean(Master$max_prev, na.rm = T)
#mean(Master$min_prev, na.rm = T)
#mean(Master$mean_prev, na.rm = T)
#mean(Master$median_prev, na.rm = T)
#cor(Master$max_prev, Master$median_prev, use = "pairwise")